//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for IBM Notebooks
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//  Last Update: 02 May 2007
//
public static class IBM
{

    #region Notebook IBM A31 2652-M3U : class A31
    //
    // class author    : Milos Popovic
    // date            : Sep 25, 2006
    // tested on model : A31 2652-M3U
    //
    // Sources:
    //      - Thinklight and Beep classes taken from Spawn/Carl Brunner's T43 class
    //      - ACPI addresses and  found from Linux ACPI info and Thinkpad wiki:
    //                    http://thinkwiki.org/wiki/ACPI_fan_control_script
    //                    http://thinkwiki.org/wiki/How_to_control_fan_speed
    //        +- ...and from Shimodax's tpfancontrol utility,
    //        +- ...and from DSL file of A31 2652-M3U
    //      - Meaning of each temperature sensor for A31 determined by freeze spraying the motherboard
    //
    // If the class NHC_WRITE is available, nhc_minimum_value = 0 and nhc_maximum_value = 1 then
    // the unit value "OFF|ON" is interpreted as "OFF" for the value 0 and "ON" for the value 1
    //
    public static class A31
    {
        static readonly string[] TSENSORNAMES = {"CPU   ","BAT1  ","PWR   ","UBAT1","BUS   ","PCM   ","BAT2  ","UBAT2","0xC0  ","0xC1  ","0xC2  ","0xC3  "}; // A31 (note change from public const to public static for "description" field)
        static readonly int[]    TSENSORADDR  = {-1,-1,-1,-1,-1,-1,-1,-1,0xc0,0xc1,0xc2,0xc3}; // A31 temperature sensor addresses in EC memory
        // Above: -1 = use TMP0,TMP1,TMP2...; other value = address in embedded controller (EC) memory 
        static readonly int[]    TSENSORACTIVEDEFAULT = {1,1,1,1,1,1,1,1,0,0,0,0};  // Default choice of active temp sensors
        static readonly string   CMOSFCN      = "CMOS";                             // A31 = CMOS, T43 = UCMS
        static readonly int      TMP_INVALID  = 128;                                // Value given by EC when memory location does correspond to a temp sensor exists in principle but no reading is available
        static readonly int[]    FANLEVELDEFAULTS = {0,3,4,7};                      // A31 default fan speed levels for OFF, LOW, HIGH
        static readonly int[]    FANTHRESHOLDDEFAULTS = {47,50,55,60,70};           // A31 default fan temperature thresholds for switching between speed levels
//        static readonly int[]    TSENSOR_NHCON  = {1,1,1,1,1,1,1,1,0,0,0,0};      // Choose sensors visible in NHC for this model
//        static readonly int[]    FANLEVEL_NHCON = {1,1,1,1};                      // Choose fanlevels visible in NHC for this model


        #region Example class for Temperature Sensors : class TEMP
        //
        public static class TEMP
        {
            // Default constants for the hardware class
            public const  string description = "Temperature Sensors [0 = deactivated, -1 = no UltraBay 2000 battery]"; // Description of current class
            public const  bool   default_enabled = true;                             // true = By default the current class is enabled in NHC
            public const  int    icon = 1;                                          // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool   initialisation = false;                            // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

/*            class TEMPBASECLASS
            {
                public const bool   nhc_visible = true;                             // true -> value is visible in NHC
                public const string unit = " °C";
            }*/
            #region  Value class for max "active" temperature, i.e. used for fan control : class TMP_MAX_ACTIVE
            //
            public static class TMP_MAX_ACTIVE // : public TEMPBASECLASS
            {
                // Properties of the value class
                public const  string description = "Maximum active temperature";    // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp_max_active;                                // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            //
            #endregion
            #region  Value class for temperature sensor 0 : class TMP0
            public static class TMP0
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[0];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp0;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 1 : class TMP1
            public static class TMP1
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[1];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp1;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 2 : class TMP2
            public static class TMP2
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[2];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp2;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 3 : class TMP3
            public static class TMP3
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[3];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp3;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 4 : class TMP4
            public static class TMP4
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[4];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp4;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 5 : class TMP5
            public static class TMP5
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[5];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp5;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 6 : class TMP6
            public static class TMP6
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[6];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp6;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 7 : class TMP7
            public static class TMP7
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[7];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp7;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 8 : class TMP8
            public static class TMP8
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[8];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp8;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 9 : class TMP9
            public static class TMP9
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[9];                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp9;                                          // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 10 : class TMP10
            public static class TMP10
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[10];                // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp10;                                         // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            #region  Value class for temperature sensor 11 : class TMP11
            public static class TMP11
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[11];                // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp11;                                         // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
            }
            #endregion
            
            // Choosing active temperatures for fan control
            #region  Value class for temperature sensor 0 active : class TMP0_ACTIVE
            public static class TMP0_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[0] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp0_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[0];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 1 active : class TMP1_ACTIVE
            public static class TMP1_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[1] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp1_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[1];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 2 active : class TMP2_ACTIVE
            public static class TMP2_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[2] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp2_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[2];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 3 active : class TMP3_ACTIVE
            public static class TMP3_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[3] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp3_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[3];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 4 active : class TMP4_ACTIVE
            public static class TMP4_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[4] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp4_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[4];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 5 active : class TMP5_ACTIVE
            public static class TMP5_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[5] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp5_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[5];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 6 active : class TMP6_ACTIVE
            public static class TMP6_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[6] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp6_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[6];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 7 active : class TMP7_ACTIVE
            public static class TMP7_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[7] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp7_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[7];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 8 active : class TMP8_ACTIVE
            public static class TMP8_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[8] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp8_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[8];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 9 active : class TMP9_ACTIVE
            public static class TMP9_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[9] + " Active";     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp9_active;                                   // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[9];  // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 10 active : class TMP10_ACTIVE
            public static class TMP10_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[10] + " Active";    // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp10_active;                                  // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[10]; // the default value of example_value
                }
            }
            #endregion
            #region  Value class for temperature sensor 11 active : class TMP11_ACTIVE
            public static class TMP11_ACTIVE
            {
                // Properties of the value class
                public static string description = TSENSORNAMES[11] + " Active";    // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    tmp11_active;                                  // It must have the same name as the class (case are ignored)
                public const  string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public static int nhc_default_value = TSENSORACTIVEDEFAULT[11]; // the default value of example_value
                }
            }
            #endregion

            public static int VectorMax(params int[] vals)  // Gets maximum of arbitrary number of integer input parameters
            {
                int maxval = vals[0];
                for (int i = 0+1; i < vals.Length; i++)
                    if (vals[i] > maxval)
                        maxval = vals[i];
                return maxval;
            }
            
            public static int GetMaxTemperature()
            {
                return VectorMax(TMP0.tmp0, TMP1.tmp1, TMP2.tmp2, TMP3.tmp3, TMP4.tmp4, TMP5.tmp5, TMP6.tmp6, TMP7.tmp7, TMP8.tmp8, TMP9.tmp9, TMP10.tmp10, TMP11.tmp11);
            }
            
            public static bool UpdateTemp(int tempnum, ref int tempval, int flag_active)
            {
                bool   result;
                string tsensoraddrstr;
                if(flag_active == 1)
                    if(TSENSORADDR[tempnum] == -1)                                  // Read from standard 8 ACPI temperature sensor registers, TMP0-TMP7
                    {
                        tsensoraddrstr = "_SB.PCI0.LPC.EC.TMP" + (char)((int)'0' + tempnum);
                        result = ACPI.FIELD.Read(tsensoraddrstr, ref tempval);
                    }
                    else                                                            // Read directly by offset into EC memory
                        result = ACPI.FIELD.ReadByOffset("_SB.PCI0.LPC.EC.ECOR", ref tempval, TSENSORADDR[tempnum], 8);
                else
                {
                    tempval = 0;                                                    // Default value for inactive temperatures
                    result = true;
                }

                if(result == true && tempval == TMP_INVALID)  tempval = -1;         // 128 means UltraBay battery not present - set to -1 so it gets ignored by fan control
                return result;
            }

            // optional refresh function -> NHC will call this function in the time interval which is defined in refresh_interval
            public const  int  refresh_interval = 1;                                // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                bool result = true;
                // Update temperature readings from EC
                result = (result && UpdateTemp( 0, ref TMP0.tmp0,   TMP0_ACTIVE.tmp0_active));
                result = (result && UpdateTemp( 1, ref TMP1.tmp1,   TMP1_ACTIVE.tmp1_active));
                result = (result && UpdateTemp( 2, ref TMP2.tmp2,   TMP2_ACTIVE.tmp2_active));
                result = (result && UpdateTemp( 3, ref TMP3.tmp3,   TMP3_ACTIVE.tmp3_active));
                result = (result && UpdateTemp( 4, ref TMP4.tmp4,   TMP4_ACTIVE.tmp4_active));
                result = (result && UpdateTemp( 5, ref TMP5.tmp5,   TMP5_ACTIVE.tmp5_active));
                result = (result && UpdateTemp( 6, ref TMP6.tmp6,   TMP6_ACTIVE.tmp6_active));
                result = (result && UpdateTemp( 7, ref TMP7.tmp7,   TMP7_ACTIVE.tmp7_active));
                result = (result && UpdateTemp( 8, ref TMP8.tmp8,   TMP8_ACTIVE.tmp8_active));
                result = (result && UpdateTemp( 9, ref TMP9.tmp9,   TMP9_ACTIVE.tmp9_active));
                result = (result && UpdateTemp(10, ref TMP10.tmp10, TMP10_ACTIVE.tmp10_active));
                result = (result && UpdateTemp(11, ref TMP11.tmp11, TMP11_ACTIVE.tmp11_active));
                // Update max active temperature if all temps successfully updated
                if(result == true)
                    TMP_MAX_ACTIVE.tmp_max_active = GetMaxTemperature();

                return result;
            }
        }
        //
        #endregion

        #region Class for Fan control : class FAN
        //
        public static class FAN
        {
            // Default constants for the hardware class
            public const  string description = "Fan Control";                       // Description of current class
            public const  bool   default_enabled = true;                             // true = By default the current class is enabled in NHC
            public const  int    icon = 2;                                          // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool   initialisation = false;                            // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region  Value class for the FANCTL control byte : class FANCTL
            //
            public static class FANCTL
            {
                // Properties of the value class
                public const  string description = "Fan Control";                   // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanctl;                                        // It must have the same name as the class (case are ignored)
                public const  string unit = "ON (NHC control)|OFF (automatic BIOS control)";

                // If the class NHC_WRITE is available, nhc_minimum_value = 0 and nhc_maximum_value = 1 then
                // the unit value "OFF|ON" is interpreted as "OFF" for the value 0 and "ON" for the value 1

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const int  nhc_maximum_value = 1;                        // the maximum value of example_value
                    public const int  nhc_default_value = 1;                        // the default value of example_value

                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        bool result;
                        
//                        if(!initialisation)                                         // Only toggle fan status when button pressed, not on initialisation
//                        {
                            switch (fanctl)
                            {
                                case 1:                                             // Fan was controlled by NHC -> change to BIOS control
//                                    fanctl = 1;
                                    result = ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", 0x80);
                                    result = result & ACPI.FIELD.Read("_SB.PCI0.LPC.EC.HFSP", ref FANSTATUS.fanstatus);
                                    return result;
                                case 0:                                             // Fan was controlled by BIOS -> change to NHC "smart" control
//                                    fanctl = 0;
                                    result = ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL0.fanlevel0);      // Trick it to start (at lowest fan speed and go up)
                                    return (result & UpdateFanLevel());
                                default:
                                    return false;
                            }
//                        }
//                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for the FANSTATUS control byte : class FANSTATUS
            //
            public static class FANSTATUS
            {
                // Properties of the value class
                public const  string description = "Fan Status Byte/Speed Level";   // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanstatus = -1;                                // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            #region  Value class for the FANRPM control byte : class FANRPM
            //
            public static class FANRPM
            {
                // Properties of the value class
                public const  string description = "Fan Speed";                     // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanrpm;                                        // It must have the same name as the class (case are ignored)
                public const  string unit = " RPM";
            }
            //
            #endregion

            #region  Value class for the FANLEVELi control byte : class FANLEVELi
            //
            public static class FANLEVEL0
            {
                // Properties of the value class
                public const  string description = "Fan Level Off";                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanlevel0;                                     // It must have the same name as the class (case are ignored)
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 7;                        // the maximum value of example_value
                    public static int  nhc_default_value = FANLEVELDEFAULTS[0];      // the default value of example_value
                }
            }
            public static class FANLEVEL1
            {
                // Properties of the value class
                public const  string description = "Fan Level 1  ";                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanlevel1;                                     // It must have the same name as the class (case are ignored)
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 7;                        // the maximum value of example_value
                    public static int  nhc_default_value = FANLEVELDEFAULTS[1];      // the default value of example_value
                }
            }
            public static class FANLEVEL2
            {
                // Properties of the value class
                public const  string description = "Fan Level 2  ";                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanlevel2;                                     // It must have the same name as the class (case are ignored)
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 7;                        // the maximum value of example_value
                    public static int  nhc_default_value = FANLEVELDEFAULTS[2];      // the default value of example_value
                }
            }
            public static class FANLEVEL3
            {
                // Properties of the value class
                public const  string description = "Fan Level 3  ";                 // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fanlevel3;                                     // It must have the same name as the class (case are ignored)
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 7;                        // the maximum value of example_value
                    public static int  nhc_default_value = FANLEVELDEFAULTS[3];      // the default value of example_value
                }
            }
            //
            #endregion

            #region  Value class for the FAN_THRESHOLDi control byte : class FAN_THRESHOLDi
            //
            public static class FAN_THRESHOLD0
            {
                // Properties of the value class
                public const  string description = "Fan Threshold Temperature 1->Off                       ";  // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fan_threshold0;                                // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 100;                      // the maximum value of example_value
                    public static int  nhc_default_value = FANTHRESHOLDDEFAULTS[0];      // the default value of example_value
                }
            }
            public static class FAN_THRESHOLD1
            {
                // Properties of the value class
                public const  string description = "Fan Threshold Temperature 2->1       or Off->1     ";  // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fan_threshold1;                                // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 100;                      // the maximum value of example_value
                    public static int  nhc_default_value = FANTHRESHOLDDEFAULTS[1];  // the default value of example_value
                }
            }
            public static class FAN_THRESHOLD2
            {
                // Properties of the value class
                public const  string description = "Fan Threshold Temperature 3->2       or 1->2       ";  // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fan_threshold2;                                // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 100;                      // the maximum value of example_value
                    public static int  nhc_default_value = FANTHRESHOLDDEFAULTS[2];  // the default value of example_value
                }
            }
            public static class FAN_THRESHOLD3
            {
                // Properties of the value class
                public const  string description = "Fan Threshold Temperature BIOS->3 or 2->3       ";  // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fan_threshold3;                                // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 100;                      // the maximum value of example_value
                    public static int  nhc_default_value = FANTHRESHOLDDEFAULTS[3];  // the default value of example_value
                }
            }
            public static class FAN_THRESHOLD4
            {
                // Properties of the value class
                public const  string description = "Fan Threshold Temperature                   3->BIOS ";  // Description of current value
                public const  bool   nhc_visible = true;                            // true -> value is visible in NHC

                // Value
                public static int    fan_threshold4;                                // It must have the same name as the class (case are ignored)
                public const  string unit = " °C";
                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const  bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const  int  nhc_minimum_value = 0;                        // the minimum value of example_value
                    public const  int  nhc_maximum_value = 100;                      // the maximum value of example_value
                    public static int  nhc_default_value = FANTHRESHOLDDEFAULTS[4];      // the default value of example_value
                }
            }
            //
            #endregion


            public static bool UpdateFanLevel()
            {
                if (FANSTATUS.fanstatus == FANLEVEL0.fanlevel0)
                {
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active > FAN_THRESHOLD1.fan_threshold1)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL1.fanlevel1);
                }
                if (FANSTATUS.fanstatus == FANLEVEL1.fanlevel1)
                {
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active > FAN_THRESHOLD2.fan_threshold2)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL2.fanlevel2);
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active < FAN_THRESHOLD0.fan_threshold0)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL0.fanlevel0);
                }
                if (FANSTATUS.fanstatus == FANLEVEL2.fanlevel2)
                {
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active > FAN_THRESHOLD3.fan_threshold3)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL3.fanlevel3);
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active < FAN_THRESHOLD1.fan_threshold1)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL1.fanlevel1);
                }
                if (FANSTATUS.fanstatus == FANLEVEL3.fanlevel3)
                {
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active > FAN_THRESHOLD4.fan_threshold4)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", 0x80);
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active < FAN_THRESHOLD2.fan_threshold2)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL2.fanlevel2);
                }
                if (FANSTATUS.fanstatus == 0x80)                                // Added 2006-10-15
                {
                    if (TEMP.TMP_MAX_ACTIVE.tmp_max_active < FAN_THRESHOLD3.fan_threshold3)
                        return ACPI.FIELD.Write("_SB.PCI0.LPC.EC.HFSP", FANLEVEL3.fanlevel3);
                }
                return true;
            }
            
            // optional refresh function -> NHC will call this function in the time interval which is defined in refresh_interval
            public const  int  refresh_interval = 1;                                // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                bool result = true;
                int fanlo = -1, fanhi = -1;
                result = result & ACPI.FIELD.Read("_SB.PCI0.LPC.EC.HFSP", ref FANSTATUS.fanstatus);  // get fan speed control byte (0x80 = 128 = BIOS control; 0-7 = manual fan speed control)
//                if(FANSTATUS.fanstatus == 0x80)  FANCTL.fanctl = 1;  else  FANCTL.fanctl = 0;
//                result = ACPI.FIELD.ReadByOffsetAdvanced("_SB.PCI0.LPC.EC.ECOR", ref FANSTATUS.fanstatus, 0x2F, 8, "_WAK");  // get fan status byte

                // NHC auto-controls fan, when selected (i.e. fanctl = 0)
                if (FANCTL.fanctl == 0)  result = result & UpdateFanLevel();

                // Get Fan RPM speed
                result = (result &
                    ACPI.FIELD.ReadByOffset("_SB.PCI0.LPC.EC.ECOR", ref fanlo, 0x84, 8, "ByteAcc", "NoLock", "Preserve") );  // get fan speed in RPM
                result = (result &
                    ACPI.FIELD.ReadByOffset("_SB.PCI0.LPC.EC.ECOR", ref fanhi, 0x84 + 1, 8, "ByteAcc", "NoLock", "Preserve") );  // get fan speed in RPM
                FANRPM.fanrpm = (fanhi << 8) | fanlo;
                
                return result;
            }

        }
        //
        #endregion

        #region Example class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Default constants for the hardware class
            public const  string description = "Hardware Control";                  // Description of current class
            public const  bool   default_enabled = true;                             // true = By default the current class is enabled in NHC
            public const  int    icon = 0;                                          // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool   initialisation = false;                            // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Thinklight and Beep classes taken from T43 script by Spawn/Carl Brunner
            #region  Value class for the ThinkLight : class Light
            //
            public static class ThinkLight
            {
                // Properties of the value class
                public const string description = "ThinkLight";                     // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int thinklight;                                       // It must have the same name as the class (case are ignored)
//                public static int thinklight = 1;                                   // [20060925-MP] Set an initialization value to keep light off (1 says light is "on", so first nhc_write call turns it off)
                public const string unit = "OFF|ON";                                // unit of the example_value class.
                // If the class NHC_WRITE is available, nhc_minimum_value = 0 and nhc_maximum_value = 1 then
                // the unit value "OFF|ON" is interpreted as "OFF" for the value 0 and "ON" for the value 1

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 1;                         // the maximum value of example_value
                    public const int nhc_default_value = 1;                         // the default value of example_value

                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        int cmos_cmd;

                        if(!initialisation)                                         // Toggle ThinkLight only if not initializing NHC, but user pressed OFF/ON.
                        {
                            if (!(ACPI.FIELD.Read("_SB.PCI0.LPC.EC.KBLT", ref thinklight))) return false; // Get the state from ACPI into thinklight

                            if (thinklight == 0)
                                cmos_cmd = 0x0c;                                    // ThinkLight is OFF, so turn it ON
                            else if (thinklight == 1)
                                cmos_cmd = 0x0d;                                    // ThinkLight is ON, so turn it OFF
                            else
                                return false;                                       // All other states are invalid

                            if (!(ACPI.METHOD.SetValue(CMOSFCN, cmos_cmd))) return false; // Set new ThinkLight state; if unsuccessful return error.
                        }
                        return(ACPI.FIELD.Read("_SB.PCI0.LPC.EC.KBLT", ref thinklight)); // Get the state from ACPI (return true if successfully retrieved new state)
                    }
                }
            }
            //
            #endregion

            #region  Beep : class Beep
            //cycles through the 17 different Beeps
            public static class Beep
            {
                // Properties of the value class
                public const string description = "Beep";                           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int beep = 0;                                         // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of the example_value class.
                // If the class NHC_WRITE is available, nhc_minimum_value = 0 and nhc_maximum_value = 1 then
                // the unit value "OFF|ON" is interpreted as "OFF" for the value 0 and "ON" for the value 1

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 1;                         // the maximum value of example_value
                    public const int nhc_default_value = 1;                         // the default value of example_value
                    public static int h = -1;
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        h = h + 1;
                        if (h > 17) //There exist 17 beeps (from Linux-ACPI)
                            h = 0;
                        return (ACPI.METHOD.SetValue("_SB.PCI0.LPC.EC.BEEP", h));
                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }
    //
    #endregion

}


